/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelf;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class CommunicationTileSelfNoteLeft
extends AbstractTile {
    private final CommunicationTileSelf tile;
    private final AbstractMessage message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Note noteOnMessage;
    private final YGauge yGauge;

    @Override
    public Event getEvent() {
        return this.message;
    }

    @Override
    public double getContactPointRelative() {
        return this.tile.getContactPointRelative();
    }

    public CommunicationTileSelfNoteLeft(CommunicationTileSelf tile, AbstractMessage message, Rose skin, ISkinParam skinParam, Note noteOnMessage, YGauge currentY) {
        super(tile.getStringBounder(), currentY);
        this.tile = tile;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.noteOnMessage = noteOnMessage;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
        this.tile.callbackY(y);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponentNote(this.noteOnMessage.getUsedStyles(), ComponentType.NOTE, this.noteOnMessage.getSkinParamBackcolored(this.skinParam), this.noteOnMessage.getDisplay(), this.noteOnMessage.getColors());
        return comp;
    }

    private Real getNotePosition(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        return this.tile.getMinX().addFixed(-dim.getWidth());
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = Area.create(dim.getWidth(), dim.getHeight());
        this.tile.drawU(ug);
        Real p = this.getNotePosition(stringBounder);
        comp.drawU(ug.apply(UTranslate.dx(p.getCurrentValue())), area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return Math.max(this.tile.getPreferredHeight(), dim.getHeight());
    }

    @Override
    public void addConstraints() {
        this.tile.addConstraints();
    }

    @Override
    public Real getMinX() {
        return this.getNotePosition(this.getStringBounder());
    }

    @Override
    public Real getMaxX() {
        return this.tile.getMaxX();
    }
}

