/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.IpRangeAggregationRange;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IpRangeAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, IpRangeAggregation> {
    @Nullable
    private final String field;
    @Nonnull
    private final List<IpRangeAggregationRange> ranges;
    public static final JsonpDeserializer<IpRangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpRangeAggregation::setupIpRangeAggregationDeserializer);

    private IpRangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
    }

    public static IpRangeAggregation of(Function<Builder, ObjectBuilder<IpRangeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.IpRange;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final List<IpRangeAggregationRange> ranges() {
        return this.ranges;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (IpRangeAggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIpRangeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        IpRangeAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(IpRangeAggregationRange._DESERIALIZER), "ranges");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.ranges);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpRangeAggregation other = (IpRangeAggregation)o;
        return Objects.equals(this.field, other.field) && Objects.equals(this.ranges, other.ranges);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IpRangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private List<IpRangeAggregationRange> ranges;

        public Builder() {
        }

        private Builder(IpRangeAggregation o) {
            super(o);
            this.field = o.field;
            this.ranges = Builder._listCopy(o.ranges);
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ranges = Builder._listCopy(o.ranges);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ranges(List<IpRangeAggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        @Nonnull
        public final Builder ranges(IpRangeAggregationRange value, IpRangeAggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        @Nonnull
        public final Builder ranges(Function<IpRangeAggregationRange.Builder, ObjectBuilder<IpRangeAggregationRange>> fn) {
            return this.ranges(fn.apply(new IpRangeAggregationRange.Builder()).build(), new IpRangeAggregationRange[0]);
        }

        @Override
        @Nonnull
        public IpRangeAggregation build() {
            this._checkSingleUse();
            return new IpRangeAggregation(this);
        }
    }
}

