"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasInvestigationCapabilities = hasInvestigationCapabilities;
exports.isChatEnabled = isChatEnabled;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Chat configuration interface for enablement logic
 */

/**
 * Context provider configuration interface
 */

/**
 * Check if investigation capabilities are enabled in the given capabilities
 * Returns true only when capabilities.investigation.agenticFeaturesEnabled is explicitly true
 * Returns false for open source environments or when features are disabled
 */
function hasInvestigationCapabilities(capabilities) {
  var _capabilities$investi;
  return (capabilities === null || capabilities === void 0 || (_capabilities$investi = capabilities.investigation) === null || _capabilities$investi === void 0 ? void 0 : _capabilities$investi.agenticFeaturesEnabled) === true;
}

/**
 * Unified chat enablement logic that works across all environments
 *
 * This function provides a single source of truth for determining whether
 * chat functionality should be enabled, handling both open source and
 * environments with investigation capabilities in a unified way.
 *
 * @param config Chat plugin configuration (includes enabled flag and agUiUrl)
 * @param contextProviderConfig Context provider configuration
 * @param capabilities Core application capabilities (may include investigation.agenticFeaturesEnabled)
 * @returns true if chat should be enabled, false otherwise
 */
function isChatEnabled(config, contextProviderConfig, capabilities) {
  // Base requirement: both chat plugin and context provider must be enabled
  if (!config.enabled || !contextProviderConfig.enabled) {
    return false;
  }

  // Environment detection: if agUiUrl is configured, this means a setup for agent endpoint for chat
  if (config.agUiUrl) {
    return true;
  }

  // Environment detection: if no agUiUrl config, we allow feature flag to control
  return hasInvestigationCapabilities(capabilities);
}