/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.hive.model.HiveDataSourceInfo;
import org.jkiss.dbeaver.ext.hive.model.HiveSQLDialect;
import org.jkiss.dbeaver.ext.hive.model.jdbc.HiveJdbcFactory;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;

public class HiveDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(HiveDataSource.class);
    private static final String CONNECTION_CLOSED_MESSAGE = "Connection is closed";

    public HiveDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new HiveSQLDialect());
    }

    protected HiveDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new HiveDataSourceInfo(monitor, (DBPDataSource)this, metaData);
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new HiveJdbcFactory();
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error instanceof SQLException && CONNECTION_CLOSED_MESSAGE.equals(error.getMessage())) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        String sqlState = SQLState.getStateFromException((Throwable)error);
        if (SQLState.SQL_08S01.getCode().equals(sqlState)) {
            return DBPErrorAssistant.ErrorType.NORMAL;
        }
        return super.discoverErrorType(error);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(true, false);
        }
        return null;
    }
}

