#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
module: organizations_uplinks_statuses_info
short_description: Information module for organizations _uplinks _statuses
description:
  - Information module for Organizations Uplinks Statuses Info.
  - Get all organizations _uplinks _statuses.
  - List the uplink status of every Meraki MX, MG and Z series devices in the organization.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.meraki.module_info
  - cisco.meraki.module_info_pagination
author: Francisco Munoz (@fmunoz)
options:
  headers:
    description: Additional headers.
    type: dict
  organizationId:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - OrganizationId path parameter. Organization ID.
    type: str
  perPage:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - PerPage query parameter. The number of entries per page returned. Acceptable
        range is 3 - 1000. Default is 1000.
    type: int
  startingAfter:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - >
        StartingAfter query parameter. A token used by the server to indicate the
        start of the page. Often this is a timestamp or an ID but it is not limited
        to those. This parameter should not be defined by client applications. The
        link for the first, last, prev, or next page in the HTTP Link header should
        define it.
    type: str
  endingBefore:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - >
        EndingBefore query parameter. A token used by the server to indicate the end
        of the page. Often this is a timestamp or an ID but it is not limited to those.
        This parameter should not be defined by client applications. The link for
        the first, last, prev, or next page in the HTTP Link header should define
        it.
    type: str
  networkIds:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - >
        NetworkIds query parameter. A list of network IDs. The returned devices will
        be filtered to only include these networks.
    elements: str
    type: list
  serials:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - >
        Serials query parameter. A list of serial numbers. The returned devices will
        be filtered to only include these serials.
    elements: str
    type: list
  iccids:
    description:
      - Information module for Organizations Uplinks Statuses Info.
      - Iccids query parameter. A list of ICCIDs. The returned devices will be filtered
        to only include these ICCIDs.
    elements: str
    type: list
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco Meraki documentation for organizations getOrganizationUplinksStatuses
    description: Complete reference of the getOrganizationUplinksStatuses API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-organization-uplinks-statuses
notes:
  - SDK Method used are
    organizations.Organizations.get_organization_uplinks_statuses,
  - Paths used are
    get /organizations/{organizationId}/uplinks/statuses,
"""

EXAMPLES = r"""
- name: Get all organizations _uplinks _statuses
  cisco.meraki.organizations_uplinks_statuses_info:
    meraki_api_key: "{{ meraki_api_key }}"
    meraki_base_url: "{{ meraki_base_url }}"
    meraki_single_request_timeout: "{{ meraki_single_request_timeout }}"
    meraki_certificate_path: "{{ meraki_certificate_path }}"
    meraki_requests_proxy: "{{ meraki_requests_proxy }}"
    meraki_wait_on_rate_limit: "{{ meraki_wait_on_rate_limit }}"
    meraki_nginx_429_retry_wait_time: "{{ meraki_nginx_429_retry_wait_time }}"
    meraki_action_batch_retry_wait_time: "{{ meraki_action_batch_retry_wait_time }}"
    meraki_retry_4xx_error: "{{ meraki_retry_4xx_error }}"
    meraki_retry_4xx_error_wait_time: "{{ meraki_retry_4xx_error_wait_time }}"
    meraki_maximum_retries: "{{ meraki_maximum_retries }}"
    meraki_output_log: "{{ meraki_output_log }}"
    meraki_log_file_prefix: "{{ meraki_log_file_prefix }}"
    meraki_log_path: "{{ meraki_log_path }}"
    meraki_print_console: "{{ meraki_print_console }}"
    meraki_suppress_logging: "{{ meraki_suppress_logging }}"
    meraki_simulate: "{{ meraki_simulate }}"
    meraki_be_geo_id: "{{ meraki_be_geo_id }}"
    meraki_caller: "{{ meraki_caller }}"
    meraki_use_iterator_for_get_pages: "{{ meraki_use_iterator_for_get_pages }}"
    meraki_inherit_logging_config: "{{ meraki_inherit_logging_config }}"
    perPage: 0
    startingAfter: string
    endingBefore: string
    networkIds: []
    serials: []
    iccids: []
    organizationId: string
    total_pages: -1
    direction: next
  register: result
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: list
  elements: dict
  sample: >
    [
      {
        "networkId": "string",
        "serial": "string",
        "model": "string",
        "lastReportedAt": "string",
        "highAvailability": {
          "enabled": true,
          "role": "string"
        },
        "uplinks": [
          {
            "interface": "string",
            "status": "string",
            "ip": "string",
            "gateway": "string",
            "publicIp": "string",
            "primaryDns": "string",
            "secondaryDns": "string",
            "ipAssignedBy": "string",
            "provider": "string",
            "signalStat": {
              "rsrp": "string",
              "rsrq": "string"
            },
            "mcc": "string",
            "mnc": "string",
            "roaming": {
              "status": "string"
            },
            "connectionType": "string",
            "apn": "string",
            "dns1": "string",
            "dns2": "string",
            "signalType": "string",
            "mtu": 0,
            "iccid": "string",
            "imsi": "string",
            "msisdn": "string"
          }
        ]
      }
    ]
"""
